# Microsoft Teams by Graph

> Note: The use of the scripts requires the PowerShell Microsoft.Graph.Teams,
<br>serveral Microsoft.Graph.Groups.

+ [Copy-MGTTeam.ps1](./Copy-MGTTeam.ps1)

  Copies a Team

+ [Get-MGTCatalogTeamApp.ps1](./Get-MGTCatalogTeamApp.ps1)

  Get teams apps from app catalogs

+ [Get-MGTCatalogTeamAppDefinition.ps1](./Get-MGTCatalogTeamAppDefinition.ps1)

  The details for each version of the app

+ [Get-MGTGroupTeam.ps1](./Get-MGTGroupTeam.ps1)

  Get team from group

+ [Get-MGTGroupTeamChannel.ps1](./Get-MGTGroupTeamChannel.ps1)

  Collection of channels and messages associated with the group

+ [Get-MGTGroupTeamOperation.ps1](./Get-MGTGroupTeamOperation.ps1)

  Get operations from groups

+ [Get-MGTTeam.ps1](./Get-MGTTeam.ps1)

  Returns the Team

+ [Get-MGTTeamChannel.ps1](./Get-MGTTeamChannel.ps1)

  Collection of channels and messages associated with the team

+ [Get-MGTTeamChannelFileFolder.ps1](./Get-MGTTeamChannelFileFolder.ps1)

  Metadata for the location where the channel's files are stored

+ [Get-MGTTeamChannelMember.ps1](./Get-MGTTeamChannelMember.ps1)

  A collection of membership records associated with the channel

+ [Get-MGTTeamChannelTab.ps1](./Get-MGTTeamChannelTab.ps1)

  A collection of all the tabs in the channel

+ [Get-MGTTeamIncomingChannel.ps1](./Get-MGTTeamIncomingChannel.ps1)

  Get incoming Channels from teams

+ [Get-MGTTeamMember.ps1](./Get-MGTTeamMember.ps1)

  Members and owners of the team

+ [Get-MGTTeamOperation.ps1](./Get-MGTTeamOperation.ps1)

  The async operations that ran or are running on this team

+ [Get-MGTTeamPhoto.ps1](./Get-MGTTeamPhoto.ps1)

  Get photo from teams

+ [Get-MGTTeamPhotoContent.ps1](./Get-MGTTeamPhotoContent.ps1)

  Get media content for the navigation property photo from teams

+ [Get-MGTTeamWork.ps1](./Get-MGTTeamWork.ps1)
  
  Get teamwork

+ [Get-MGTUserChat.ps1](./Get-MGTUserChat.ps1)
  
  Get chats from users

+ [Get-MGTUserJoinedTeam.ps1](./Get-MGTUserJoinedTeam.ps1)
  
  Microsoft Teams teams that the user is a member of

+ [Get-MGTUserTeamWork.ps1](./Get-MGTUserTeamWork.ps1)
  
  Container for Microsoft Teams features available for the user

+ [Get-MGTUserTeamWorkAssociatedTeam.ps1](./Get-MGTUserTeamWorkAssociatedTeam.ps1)
  
  Get associatedTeams from users

+ [Get-MGTUserTeamWorkInstalledApp.ps1](./Get-MGTUserTeamWorkInstalledApp.ps1)
  
  Apps installed in the personal scope of this user

+ [Invoke-MGTArchiveTeam.ps1](./Invoke-MGTArchiveTeam.ps1)

  Invoke action archive/unarchive

+ [New-MGTGroupTeamChannel.ps1](./New-MGTGroupTeamChannel.ps1)

  Create new navigation property to channels for groups

+ [New-MGTTeam.ps1](./New-MGTTeam.ps1)

  Creates a Team

+ [New-MGTTeamChannel.ps1](./New-MGTTeamChannel.ps1)

  Creates a team channel

+ [Remove-MGTGroupTeam.ps1](./Remove-MGTGroupTeam.ps1)

  Delete navigation property team for groups

+ [Remove-MGTGroupTeamChannel.ps1](./Remove-MGTGroupTeamChannel.ps1)

  Delete navigation property channels for groups

+ [Remove-MGTTeam.ps1](./Remove-MGTTeam.ps1)

  Removes a Team

+ [Remove-MGTTeamChannel.ps1](./Remove-MGTTeamChannel.ps1)

  Removes a team channel

+ [Remove-MGTTeamChannelFileFolder.ps1](./Remove-MGTTeamChannelFileFolder.ps1)

  Removes the location where the channel's files are stored

+ [Remove-MGTTeamChannelTab.ps1](./Remove-MGTTeamChannelTab.ps1)

  Removes the channel tab of the team

+ [Remove-MGTTeamMember.ps1](./Remove-MGTTeamMember.ps1)

  Removes a member from the team

+ [Remove-MGTUserTeamWorkInstalledApp.ps1](./Remove-MGTUserTeamWorkInstalledApp.ps1)
  
  Removes a app installed in the personal scope of this user

+ [Set-MGTGroupTeam.ps1](./Set-MGTGroupTeam.ps1)

  Update the navigation property team in groups

+ [Set-MGTGroupTeamChannel.ps1](./Set-MGTGroupTeamChannel.ps1)

  Update the navigation property channels in groups

+ [Set-MGTTeam.ps1](./Set-MGTTeam.ps1)

  Updates a Team

+ [Set-MGTTeamChannel.ps1](./Set-MGTTeamChannel.ps1)

  Updates a team channel

+ [Set-MGTTeamChannelTab.ps1](./Set-MGTTeamChannelTab.ps1)

  Updates a team channel tab

+ [Set-MGTTeamPhotoContent.ps1](./Set-MGTTeamPhotoContent.ps1)

  Update media content for the navigation property photo in teams

## [Queries](./_QUERY_)

+ Search teams
+ Search team channels 
+ Search team channel tabs
+ Search team members
+ Search team apps
+ Search user team work installed apps